import dynamic from "next/dynamic";
import { headers } from "next/headers";
const ContactUs = dynamic(() => import("@/sections/ContactUs"));
const Brochure = dynamic(() => import("@/sections/Brochure"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const FarazForm = dynamic(() => import("@/sections/FarazForm"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export async function generateMetadata() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return {
    metadataBase: new URL(`https://${domain}/contact-us`),
    title: "Contact Us Get in Touch with Our Real Estate Experts",
    description:
      "Have questions about buying or selling property? Contact our team for expert real estate advice and assistance. We’re here to help.",
    keywords: [""],
    alternates: {
      canonical: "/contact-us",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default function page() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return (
    <>
      <WebsiteSchema
        title="Contact Us Get in Touch with Our Real Estate Experts"
        description="Have questions about buying or selling property? Contact our team for expert real estate advice and assistance. We’re here to help."
        keywords=""
        fullUrl={`https://${domain}/contact-us`}
      />
      <RatingSchema title="Contact Us Get in Touch with Our Real Estate Experts" />
      <ContactUs domain={domain} />
      <FarazForm />
      <Brochure />
    </>
  );
}
