import dynamic from "next/dynamic";
import { headers } from "next/headers";
import { HomeData } from "@/data/data";
import { FetchData } from "@/libs/api";
const VideoTour = dynamic(() => import("@/sections/VideoTour"));
const OffPlanCardsList = dynamic(() => import("@/sections/OffPlanCardsList"));
const OpenGallery = dynamic(() => import("@/sections/OpenGallery"));
const ImageSec = dynamic(() => import("@/sections/ImageSec"));
const FarazForm = dynamic(() => import("@/sections/FarazForm"));
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const Cluster = dynamic(() => import("@/sections/Cluster"));
const FloorPlanDetail = dynamic(() => import("@/sections/FloorPlanDetail"));
const Location = dynamic(() => import("@/sections/Location"));
const Brochure = dynamic(() => import("@/sections/Brochure"));
const About2 = dynamic(() => import("@/sections/About2"));
const Gallery = dynamic(() => import("@/sections/Gallery"));
const Hero = dynamic(() => import("@/sections/Hero"));
const Faqs = dynamic(() => import("@/sections/Faqs"));
const PaymentPlan = dynamic(() => import("@/sections/PaymentPlan"));
const Amenities = dynamic(() => import("@/sections/Amenities"));
const FaqsSchema = dynamic(() => import("@/components/Schema/FaqsSchema"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  const data = HomeData;
  const { info } = data;
  const { meta_title, meta_desc, meta_keywords, cover_iamge, community_name } =
    info;
  return {
    metadataBase: new URL(`https://${domain}`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      type: "website",
      siteName: community_name,
      url: "/",
      images: {
        url: cover_iamge,
        width: 100,
        height: 100,
      },
    },
  };
}
export default async function Home() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  const data = HomeData;
  const projects = await FetchData();
  const {
    info,
    interior_gallery,
    exterior_gallery,
    gallery_heading,
    payment_plan,
    faqs,
    Floor_plan,
    amenities,
    floorplan_content,
  } = data;
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    community_name,
    short_content,
    about_image,
    cover_iamge,
  } = info;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}`}
      />
      <RatingSchema title={meta_title} />
      <FaqsSchema faqs={faqs} />
      <Hero info={info} cover_iamge={cover_iamge} />
      <div className="PaymentPlan mt-4" id="paymentplan">
        <h2 className="text-black text-center mainh2">
          Exclusive Waterfront Apartments & Penthouses in a luxury 39-floor
          Residential Complex
        </h2>
      </div>
      <About2
        content={short_content}
        img={about_image}
        comuname={community_name}
      />
      <PaymentPlan
        payment_plan={payment_plan}
        community_name={community_name}
      />
      {projects ? (
        <OffPlanCardsList
          data={projects}
          heading="Properties for Sale in Dubai Maritime City"
          content="Properties for sale in Dubai Maritime City offer a unique blend of luxury waterfront living and high investment potential. Located in a prime maritime hub, this area features modern apartments, upscale residences, and commercial properties with stunning sea views. With its strategic location and growing infrastructure, Dubai Maritime City is becoming a sought-after destination for investors and homebuyers looking for premium real estate in Dubai."
          domain={domain}
          cardsQuantity="12"
        />
      ) : (
        ""
      )}
      <Amenities amenities={amenities} />
      <FloorPlanDetail Floor_plan={Floor_plan} content={floorplan_content} />
      <ImageSec />
      <Cluster />
      <VideoTour />
      <OpenGallery interiorGallery={interior_gallery} />
      <Location />
      <Gallery
        exteriorGallery={exterior_gallery}
        interiorGallery={interior_gallery}
        gallery_heading={gallery_heading}
      />
      <ContentSec
        content={`<h2>Off-Plan Projects in Maritime City</h2>
<p>Off-plan developments in Dubai Maritime City provide buyers with the chance to invest early in some of the most exciting new projects. With flexible payment plans and competitive prices, these developments offer strong capital appreciation potential. Some of the standout off-plan projects in Maritime City include:</p>
<p><strong>-Sensia by Beyond</strong><br />Sensia by Beyond is a premium waterfront development offering elegantly designed apartments with modern architecture and high-end finishes. With breathtaking sea views and luxurious amenities, this project is perfect for those seeking a sophisticated lifestyle in Dubai Maritime City.</p>
<p><strong>-Saria by Beyond</strong><br />Saria by Beyond is another remarkable project featuring spacious residences designed for ultimate comfort and elegance. With top-tier facilities, smart home technology, and a prime location, this development is set to become a sought-after address for homebuyers and investors alike.</p>
<p><strong>-Orise by Beyond</strong><br />Orise by Beyond is redefining waterfront living with its contemporary design, high-quality craftsmanship, and world-class amenities. Offering a range of apartments with stunning marina views, this project presents an excellent opportunity for those looking to invest in Dubai&rsquo;s dynamic real estate market.</p>
<h3>New Projects in Maritime City</h3>
<p>Several new projects in Maritime City are redefining waterfront living with state-of-the-art designs and world-class amenities. From sleek high-rise towers to exclusive beachfront developments, the area is attracting those seeking contemporary and stylish residences.</p>
<h3>Apartments for Sale in Maritime City</h3>
<p>For those looking for apartments for sale in Maritime City, a variety of options are available, ranging from modern studios to spacious multi-bedroom units. With stunning sea views, premium finishes, and top-tier facilities, these apartments provide the perfect combination of luxury and convenience.</p>
<h3>Villas for Sale in Maritime City</h3>
<p>If you prefer a more private and spacious residence, villas for sale in Maritime City offer the ultimate in luxury living. These properties come with expansive layouts, private pools, and direct waterfront access, providing an exclusive lifestyle for homeowners.</p>
<h3>Properties for Sale in Maritime City</h3>
<p>Whether you're looking for a new home or an investment, properties for sale in Maritime City promise high returns and an upscale living experience. With a growing number of high-end developments, the area is becoming a hotspot for real estate investment in Dubai.</p>
<h3>Buy Property in Maritime City</h3>
<p>If you&rsquo;re considering investing in Dubai, now is the perfect time to buy property in Maritime City. With competitive prices, flexible payment plans, and strong growth potential, this waterfront district is attracting investors from around the world.</p>
<h3>Buy Apartment in Maritime City</h3>
<p>For those looking to buy an apartment in Maritime City, the district offers a range of luxury residences with breathtaking marina views and world-class amenities. From stylish one-bedroom apartments to expansive penthouses, there is something for every buyer.</p>
<h3>Dubai Maritime City Projects</h3>
<p>The latest Dubai Maritime City projects feature a mix of residential, commercial, and leisure developments, making it one of the most exciting areas for real estate investment. With a focus on sustainability and innovation, these projects are set to redefine Dubai&rsquo;s skyline.</p>
<h3>House for Sale in Maritime City</h3>
<p>Looking for a house for sale in Maritime City? Whether you prefer a modern apartment or a spacious villa, this area offers stunning waterfront residences designed to meet diverse lifestyle needs.</p>
<h3>New Apartments for Sale in Maritime City</h3>
<p>Explore new apartments for sale in Maritime City, featuring contemporary designs, high-end interiors, and unparalleled views of the Arabian Gulf. These newly launched projects provide excellent investment opportunities for buyers seeking long-term value.</p>
<h3>Luxury Apartments in Maritime City</h3>
<p>For those seeking an upscale lifestyle, luxury apartments in Maritime City offer exquisite architecture, exclusive facilities, and prime waterfront locations. These properties are designed to provide residents with the highest level of comfort and sophistication.</p>
<h3>Waterfront Apartments Maritime City</h3>
<p>Enjoy breathtaking views and direct beach access with waterfront apartments in Maritime City. These residences are perfect for those who love coastal living while staying close to Dubai&rsquo;s vibrant city life.</p>
<h3>Waterfront Project in Dubai Maritime City</h3>
<p>The latest waterfront project in Dubai Maritime City is set to transform the area into a world-class residential and commercial hub. With innovative designs, premium amenities, and stunning seaside views, it&rsquo;s an ideal location for both investors and homebuyers.</p>`}
      />
      <Faqs faqs={faqs} />
      <FarazForm />
      <Brochure />
    </>
  );
}
