import dynamic from "next/dynamic";
import { domain } from "@/domain/domain";
import { FetchData } from "@/libs/api";
const FarazForm = dynamic(() => import("@/sections/FarazForm"));
const OffPlanCardsList = dynamic(() => import("@/sections/OffPlanCardsList"));
const Brochure = dynamic(() => import("@/sections/Brochure"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const meta_title = "New Off Plan Projects in Dubai Maritime City";
  const meta_desc =
    "New Off Plan Projects in Maritime City· Orise by Beyond, Saria, Jumeirah Peninsula, Sensia by Beyond, Anwa Phase 2 By Omniyat Group ";
  const meta_keywords =
    "New Off Plan Projects in Dubai Maritime City, Projects in Dubai Maritime City, Projects in DMC, Waterfront Projects in Dubai Maritime City";
  return {
    metadataBase: new URL(`https://${domain}/projects`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page() {
  const meta_title = "New Off Plan Projects in Dubai Maritime City";
  const meta_desc =
    "New Off Plan Projects in Maritime City· Orise by Beyond, Saria, Jumeirah Peninsula, Sensia by Beyond, Anwa Phase 2 By Omniyat Group ";
  const meta_keywords =
    "New Off Plan Projects in Dubai Maritime City, Projects in Dubai Maritime City, Projects in DMC, Waterfront Projects in Dubai Maritime City";
  const projects = await FetchData();
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/projects`}
      />
      <RatingSchema title={meta_title} />
      <OffPlanCardsList
        data={projects}
        heading="New Off Plan Projects in Dubai Maritime City"
        content="New off-plan projects in Dubai Maritime City offer investors and homebuyers a unique opportunity to own premium waterfront properties in one of Dubai’s most promising real estate hubs. With modern architecture, world-class amenities, and flexible payment plans, these developments provide high investment potential and a luxurious lifestyle. As the area continues to grow, these new projects are set to redefine waterfront living, making them an ideal choice for those seeking a vibrant and upscale community."
        domain={domain}
        cardsQuantity="12"
      />
      <FarazForm />
      <Brochure />
    </>
  );
}
