import React from "react";
const DetailsSection = ({ type, size, bedroom, community_name, price }) => {
  return (
    <>
      <div className="bg-light Overview" id="overview">
        <h2>Overview</h2>
      </div>
      <div className="details-section">
        <div className="details-header">Details</div>
        <div className="details-row">
          <div className="details-column">
            <div className="detail-item">
              <div className="detail-label">Type</div>
              <div className="detail-value">{type}</div>
            </div>
            <div className="detail-item">
              <div className="detail-label">Price</div>
              <div className="detail-value">{price}</div>
            </div>
            <div className="detail-item">
              <div className="detail-label">Location</div>
              <div className="detail-value">{community_name}</div>
            </div>
          </div>
          <div className="details-column">
            <div className="detail-item">
              <div className="detail-label">Area</div>
              <div className="detail-value">{size}</div>
            </div>
            <div className="detail-item">
              <div className="detail-label">Purpose</div>
              <div className="detail-value">For Sale</div>
            </div>
            <div className="detail-item">
              <div className="detail-label">Bedroom(s)</div>
              <div className="detail-value">{bedroom}</div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
};

export default DetailsSection;
