import Link from "next/link";

export default function Footer({ domain, community_name }) {
  const currentYear = new Date().getFullYear();
  return (
    <>
      <footer class="footer-butom">
        <div class="container p-4 pb-0 text-white">
          <div class="row">
            <div class="col-md-3 col-lg-3 col-xl-3 mx-auto mt-3">
              <h6 class="text-uppercase mb-1">{community_name}</h6>
              <p>
                Here you can use rows and columns to organize your footer
                content. Lorem ipsum dolor sit amet, consectetur adipisicing
                elit.
              </p>
            </div>
            <hr class="w-100 clearfix d-md-none" />
            <div class="col-md-2 col-lg-2 col-xl-2 mx-auto mt-3">
              <h6 class="text-uppercase mb-1">Products</h6>
              <p>
                <a class="text-white">MDBootstrap</a>
              </p>
              <p>
                <a class="text-white">MDWordPress</a>
              </p>
              <p>
                <a class="text-white">BrandFlow</a>
              </p>
              <p>
                <a class="text-white">Bootstrap Angular</a>
              </p>
            </div>
            <hr class="w-100 clearfix d-md-none" />
            <div class="col-md-3 col-lg-2 col-xl-2 mx-auto mt-3">
              <h6 class="text-uppercase mb-1">Useful links</h6>
              <p>
                <a class="text-white">Your Account</a>
              </p>
              <p>
                <a class="text-white">Become an Affiliate</a>
              </p>
              <p>
                <a class="text-white">Shipping Rates</a>
              </p>
              <p>
                <a class="text-white">Help</a>
              </p>
            </div>
            <hr class="w-100 clearfix d-md-none" />
            <div class="col-md-4 col-lg-3 col-xl-3 mx-auto mt-3">
              <h6 class="text-uppercase mb-1">Contact</h6>
              <p>
                <i class="fas fa-home mr-3"></i> New York, NY 10012, US
              </p>
              <p>
                <i class="fas fa-envelope mr-3"></i> info@gmail.com
              </p>
              <p>
                <i class="fas fa-phone mr-3"></i> + 01 234 567 88
              </p>
              <p>
                <i class="fas fa-print mr-3"></i> + 01 234 567 89
              </p>
            </div>
          </div>

          <hr class="my-3" />

          <div class="p-3 pt-0">
            <div class="row d-flex align-items-center">
              <div class="col-md-7 col-lg-8 text-center text-md-start">
                <div class="p-1">
                  © {currentYear} Copyright :
                  <Link class="text-white" href="/">
                    {domain}
                  </Link>
                </div>
              </div>
              {/* <!-- Grid column --> */}
            </div>
            {/* <!-- Section: Copyright --> */}
          </div>
        </div>
        {/* <!-- Grid container --> */}
      </footer>
      <div className="container-fluid footer">
        <div className="w-100 d-flex justify-content-center align-items-center p-3 fs-6">
          <a href="/" className="text-white">
            &copy; {domain} {currentYear}
          </a>
        </div>
      </div>
    </>
  );
}
