import { Headeritems } from "@/data/data";
import dynamic from "next/dynamic";
import Image from "next/image";
import Link from "next/link";
const MobileNav = dynamic(() => import("./MobileNav"));
const HeaderWhatsApp = dynamic(() => import("./HeaderWhatsApp"));
export default function Header({ info }) {
  const navData = Headeritems;
  const { logo_image, community_name } = info;
  return (
    <>
      <header className="DetailHeader-container py-0">
        <div className="d-none d-lg-block d-xl-block">
          <nav className="navbar navbar-expand-lg navbar-dark p-0">
            <a className="navbar-brand" href="/">
              <Image
                src={logo_image}
                width={300}
                height={300}
                priority={true}
                alt="logo"
                className="logo_img"
              />
            </a>
            <button
              className="navbar-toggler"
              type="button"
              data-toggle="collapse"
              data-target="#navbarNav"
              aria-controls="navbarNav"
              aria-expanded="false"
              aria-label="Toggle navigation"
            >
              <span className="navbar-toggler-icon"></span>
            </button>
            <div className="collapse navbar-collapse" id="navbarNav">
              <ul className="navbar-nav ml-auto text-uppercase">
                {navData?.map((item, i) => (
                  <li className="nav-item" key={i}>
                    <Link className="nav-link" href={item?.link}>
                      {item?.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            <HeaderWhatsApp community_name={community_name} />
          </nav>
        </div>
        <MobileNav info={info} />
      </header>
    </>
  );
}
