"use client";
import dynamic from "next/dynamic";
import React, { createContext, useContext, useState } from "react";
const Form = dynamic(() => import("@/components/Form"));
const Modal = dynamic(() => import("@/components/Modal"));
const ModalContext = createContext();
export const useModal = () => useContext(ModalContext);
export const ModalProvider = ({ children }) => {
  const [showModal, setShowModal] = useState(false);
  const [modalTitle, setModalTitle] = useState("");
  const [modalData, setModalData] = useState({});
  const toggleModal = (
    title,
    project_name,
    price,
    bedroom,
    size,
    community_name,
    type,
    developer,
    cardurl
  ) => {
    setModalTitle(title);
    setModalData({
      project_name,
      price,
      bedroom,
      size,
      community_name,
      type,
      developer,
      cardurl,
    });
    setShowModal((prev) => !prev);
  };

  return (
    <ModalContext.Provider value={{ toggleModal }}>
      {children}
      <Modal show={showModal} setShow={setShowModal} title={modalTitle}>
        <Form looking_for={modalTitle} modalData={modalData} />
      </Modal>
    </ModalContext.Provider>
  );
};
