import Image from "next/image";
import Link from "next/link";
const DevelopersList = ({ developers, short_content, heading1 }) => {
  return (
    <section>
      <div className="container">
        <h2 className="text-center my-4">{heading1}</h2>
        <p className="text-center mb-4">{short_content}</p>
        <div className="row justify-content-center">
          {developers.map((item, i) => (
            <div key={i} className="col-md-6 col-lg-4 mt-3">
              <Link href={`/developers/${item.slug}`}>
                <div className="developer-card">
                  <div className="card item-card">
                    <div className="card-body text-center">
                      <Image
                        src={item.developer_logo || "/images/noimg.jpg"}
                        alt={item.developer_name}
                        width={120}
                        height={120}
                        className="img-fluid"
                      />
                      <h3 className="mt-1">{item.developer_name}</h3>
                    </div>
                  </div>
                </div>
              </Link>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default DevelopersList;
