import dynamic from "next/dynamic";
import Image from "next/image";
import { FaArrowCircleRight } from "react-icons/fa";

const Form = dynamic(() => import("@/components/Form"));
const FormBtn = dynamic(() => import("@/components/FormBtn"), { ssr: false });

export default function Hero({ info, cover_iamge }) {
  const { heading1 } = info;

  return (
    <div className="GoldHero">
      <header className="hero-header">
        {/* Background Image */}
        <div className="hero-bg">
          <Image
            src={cover_iamge}
            alt={heading1}
            layout="fill"
            quality={80}
            objectFit="cover"
            priority={true}
          />
          <div className="overlay"></div>
        </div>

        {/* Hero Content */}
        <div className="container hero-content">
          <div className="row align-items-center text-center">
            {/* Left Content */}
            <div className="text-white details">
              <h1 className="main_heading">{heading1}</h1>
              <p className="my-3">Luxury 1 to 5 Waterfront Apartments</p>
              <div className="btn-group text-center w-100 mt-">
                <FormBtn
                  className="webbutton d-flex align-items-center gap-2"
                  modaltitle="Presale Consultation"
                  icon={<FaArrowCircleRight style={{ fontSize: "20px" }} />}
                />
                <FormBtn
                  className="webbutton bg-white text-black d-none d-lg-block d-xl-block"
                  modaltitle="List of exclusive offers"
                />
              </div>
            </div>

            {/* Right Form */}
            {/* <div className="col-lg-4 col-md-5 offset-lg-2">
              <div className="form-container">
                <h3 className="form-title">Show Your Interest Today</h3>
                <p className="form-description">
                  Fill out the form for exclusive property details. Our team
                  will assist you in finding your perfect home!
                </p>
                <Form looking_for="Book your free consultation" modalData="" />
              </div>
            </div> */}
          </div>
        </div>
      </header>
    </div>
  );
}
