import Image from "next/image";

export default function HeroDetail({ data }) {
  const {
    heading,
    coverImage,
    completion,
    min_size,
    minimum_price,
    payment_plan,
    community_name,
    type_names,
  } = data;
  return (
    <>
      <div className="hero-section container-fluid px-0">
        {/* Background Image */}
        <Image
          src={coverImage || ""}
          alt={heading}
          fill
          className="bg-image"
          priority
        />

        <div className="container-fluid px-0">
          <div className="col-12 text-center mb-4">
            {/* Logos */}
            {/* <div className="logo-container mb-4">
              <Image
                src="/images/logo.png"
                alt="Saria Logo"
                width={150}
                height={150}
                priority
              />
              <Image
                src="/images/omnilogo.png"
                alt="Omniyat Logo"
                width={300}
                height={100}
                priority
              />
            </div> */}
            {/* Heading */}
            <h1 className="text-white mb-5">
              {heading} at {community_name}
            </h1>
          </div>
          <div className="text-white py-5 border-top">
            <div className="row align-items-center justify-content-center text-center w-100">
              {/* Price Section */}
              <div className="col-12 col-md-4 text-md-start text-lg-start text-center mb-3 mb-md-0">
                <h4 className="fw-bold price">{minimum_price}</h4>
                <p className="text-light">Starting Price from</p>
              </div>

              {/* Payment Plan */}
              <div className="col-12 col-md-2">
                <h4 className="fw-bold">{payment_plan}</h4>
                <p className="text-light">Payment Plan</p>
              </div>

              {/* Area */}
              <div className="col-12 col-md-2">
                <h4 className="fw-bold">{min_size}</h4>
                <p className="text-light">Area from (sq. ft.)</p>
              </div>

              {/* Handover */}
              <div className="col-12 col-md-2 mt-3 mt-md-0">
                <h4 className="fw-bold">{completion}</h4>
                <p className="text-light">Handover</p>
              </div>

              {/* Property Types */}
              <div className="col-12 col-md-10 text-start mt-4">
                <div className="carsdasdas">
                  {type_names.map((item, i) => (
                    <span
                      className="webbutton bg-white text-black px-3 py-2 me-2"
                      key={i}
                    >
                      {item?.name}
                    </span>
                  ))}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
