"use client";
import OffPlanCard from "@/components/OffPlanCard";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, Navigation } from "swiper/modules";
import Link from "next/link";
const OffPlanCardsSec = ({
  data,
  heading,
  slug,
  domain,
  community_name,
  type,
}) => {
  return (
    <>
      <section className="mainCards pb-0" id="Buy">
        <div className="SaleCards" id="New_Projects">
          <div className="container-fluid px-0">
            <h2 className="pb-4 text-center">{heading}</h2>
            <div className="sale-cards-container">
              <div className="container customContainer p-0">
                <Swiper
                  breakpoints={{
                    "@0.00": {
                      slidesPerView: 1,
                    },
                    "@0.75": {
                      slidesPerView: 2,
                    },
                    "@1.00": {
                      slidesPerView: 3,
                    },
                    "@1.50": {
                      slidesPerView: 4,
                    },
                  }}
                  slidesPerView={3}
                  autoplay={{
                    delay: 2500,
                    disableOnInteraction: false,
                  }}
                  pagination={{
                    clickable: true,
                  }}
                  navigation={true}
                  modules={[Autoplay, Navigation]}
                  className="mySwiper"
                >
                  {data?.map((property, i) => (
                    <SwiperSlide key={i}>
                      <OffPlanCard
                        domain={domain}
                        property_name={property?.property_name}
                        location={property?.community_name}
                        price={property?.minimum_price}
                        img={property?.cover_image}
                        bedroom={property?.bedrooms}
                        developer={property?.developer_name}
                        types={property?.property_types}
                        size={property?.min_size}
                        slug={property?.slug}
                        usps1={property?.usps?.usps1}
                        usps2={property?.usps?.usps2}
                      />
                    </SwiperSlide>
                  ))}
                </Swiper>
                <div className="d-flex justify-content-center gap-3 mb-4">
                  <Link href={`/buy/${slug}`}>
                    <button className="webbutton mt-3">
                      View More {type} in {community_name}
                    </button>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default OffPlanCardsSec;
