import Image from "next/image";
const OpenGallery = ({ interiorGallery, heading }) => {
  return (
    <>
      <div className="container">
        {heading ? <h3 className="mb-4 text-center">{heading}</h3> : ""}
        {interiorGallery?.slice(0, 5).map((item, i) => (
          <div className="container mb-4" key={i}>
            <div className="video-tour-container">
              <Image
                style={{ objectPosition: "top" }}
                width={900}
                height={800}
                src={item?.image || ""}
                alt=""
              />
            </div>
          </div>
        ))}
      </div>
    </>
  );
};
export default OpenGallery;
