import CardComponent from "@/components/CardComponent";
export default function PropertyDetail({ data }) {
  const { community_name, min_size, minimum_price, payment_plan } = data;
  return (
    <>
      <section id="overview">
        <div className="container">
          <div className="row">
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Starting Price"}
                price={minimum_price || "Update Soon"}
                icon="/images/starting-price.svg"
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Payment Plan"}
                price={payment_plan || "Update Soon"}
                icon="/images/paymentPlan.svg"
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Location"}
                price={community_name || "Update Soon"}
                icon="/images/Location.svg"
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Size Range"}
                price={min_size || "Update Soon"}
                icon="/images/Size.svg"
              />
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
