"use client";
import { domain } from "@/app/domain";
import { useModal } from "@/context/ModalContext";
import { cardsdata } from "@/data/data";
import Image from "next/image";
const VillasSection = () => {
  const { toggleModal } = useModal();
  return (
    <section className="villas-section py-5 text-center">
      <h2 className="mb-5 mt-3  text-white">
        Wilds Community by Aldar LUXURY VILLA
      </h2>
      <div className="container">
        <div className="row gy-4">
          {cardsdata.map((villa, index) => (
            <div className="col-12 col-md-6 col-lg-3" key={index}>
              <div className="villa-card">
                <div className="villa-image">
                  <Image
                    src={villa.image}
                    alt={villa.title}
                    width={300}
                    height={200}
                    style={{
                      width: "100%",
                      height: "auto",
                      borderRadius: "8px",
                    }}
                  />
                </div>
                <h5 className="villa-title mt-3">{villa.title}</h5>
                <p className="villa-description">{villa.description}</p>
                <a
                  onClick={() =>
                    toggleModal(
                      "Enquire Now!",
                      villa.title,
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      `https://${domain}`
                    )
                  }
                >
                  <button className="webbutton bg-white text-black py-2 mt-2">
                    Enquire Now!
                  </button>
                </a>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default VillasSection;
